<?php
// file: webhook.php (Versi Final dengan /allstatus Batching & Paging)

require_once 'config.php';

// =======================================================
//          FUNGSI-FUNGSI HELPER
// =======================================================

function sendMessage($chatId, $text, $inlineKeyboard = null, $replyKeyboard = null) {
    $url = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/sendMessage";
    $replyMarkup = [];
    if ($inlineKeyboard) { $replyMarkup['inline_keyboard'] = $inlineKeyboard; }
    if ($replyKeyboard) { $replyMarkup['keyboard'] = $replyKeyboard; $replyMarkup['resize_keyboard'] = true; $replyMarkup['one_time_keyboard'] = false; }
    $postData = ['chat_id' => $chatId, 'text' => $text, 'parse_mode' => 'HTML'];
    if (!empty($replyMarkup)) { $postData['reply_markup'] = json_encode($replyMarkup); }
    $ch = curl_init($url);
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($postData), CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 10]);
    curl_exec($ch);
    curl_close($ch);
}

function editMessage($chatId, $messageId, $text, $keyboard = null) {
    $url = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/editMessageText";
    $postData = ['chat_id' => $chatId, 'message_id' => $messageId, 'text' => $text, 'parse_mode' => 'HTML'];
    if ($keyboard) { $postData['reply_markup'] = json_encode(['inline_keyboard' => $keyboard]); }
    $ch = curl_init($url);
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($postData), CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 5]);
    curl_exec($ch);
    curl_close($ch);
}

function answerCallbackQuery($callbackQueryId, $text = '', $showAlert = false) {
    $url = "https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/answerCallbackQuery";
    $postData = ['callback_query_id' => $callbackQueryId, 'text' => $text, 'show_alert' => $showAlert];
    $ch = curl_init($url);
    curl_setopt_array($ch, [CURLOPT_POST => 1, CURLOPT_POSTFIELDS => http_build_query($postData), CURLOPT_RETURNTRANSFER => true, CURLOPT_TIMEOUT => 5]);
    curl_exec($ch);
    curl_close($ch);
}

function getHelpMessage() {
    $reply  = "<b>Bantuan & Daftar Perintah</b>\n\n";
    $reply .= "Gunakan perintah atau tombol menu di bawah:\n\n";
    $reply .= "<code>/start</code> - Memulai bot & menampilkan menu.\n";
    $reply .= "<code>/list</code> - Melihat daftar domain Anda.\n";
    $reply .= "<code>/status</code> - Cek status detail per domain.\n";
    $reply .= "<code>/allstatus</code> - Cek cepat semua domain Anda.\n";
    $reply .= "<code>/cek [domain]</code> - Cek domain apapun.\n";
    $reply .= "<code>/adddomain [nama] [url]</code> - Menambah domain.\n";
    $reply .= "<code>/delete</code> - Menghapus domain.\n";
    $reply .= "<code>/replace [url_lama] [url_baru]</code> - Mengganti URL.\n";
    $reply .= "<code>/help</code> - Menampilkan bantuan ini.";
    return $reply;
}

function checkDomainViaRelay($domain) {
    global $APP_SETTINGS;
    $relay_url = ($APP_SETTINGS['relay_url'] ?? 'http://103.181.182.57/relay.php') . "?domain=" . urlencode($domain);
    $options = ["http" => ["timeout" => 20, "ignore_errors" => true]];
    $context = stream_context_create($options);
    $response_json = @file_get_contents($relay_url, false, $context);
    if ($response_json === false) { return null; }
    $data = json_decode($response_json, true);
    return (json_last_error() === JSON_ERROR_NONE && !empty($data)) ? $data : null;
}

function getDomainStatusMessage($domain_id, $domain_name, $domain_url) {
    global $conn, $providers;
    $status_stmt = $conn->prepare("SELECT provider, status, last_checked FROM domain_statuses WHERE domain_id = ?");
    $status_stmt->bind_param("i", $domain_id); $status_stmt->execute();
    $statuses_result = $status_stmt->get_result(); $statuses = [];
    while($row = $statuses_result->fetch_assoc()) { $statuses[$row['provider']] = $row; }
    if (!empty($statuses)) {
        $reply = "<b>Status Pengecekan Domain:</b>\n<b>" . e($domain_name) . "</b> (<code>" . e($domain_url) . "</code>)\n\n";
        foreach ($providers as $provider) {
            if (isset($statuses[$provider])) {
                $status_row = $statuses[$provider];
                $status_text = (strtoupper($status_row['status']) === 'BLOCKED') ? "🔴 BLOCKED" : "🟢 SAFE";
                $waktu = date('d M . H:i:s', strtotime($status_row['last_checked']));
                $reply .= "<b>" . e($provider) . ":</b> " . $status_text . " (" . $waktu . ")\n";
            }
        }
    } else { $reply = "Status untuk <b>" . e($domain_name) . "</b> masih <b>PENDING</b>."; }
    return $reply;
}

function processAllStatusBatch($user_id, $offset = 0) {
    global $conn, $providers;
    $batch_size = 10;
    $total_q = $conn->prepare("SELECT COUNT(id) as total FROM domains WHERE user_id = ? AND is_active = 1");
    $total_q->bind_param("i", $user_id); $total_q->execute();
    $total_domains = $total_q->get_result()->fetch_assoc()['total']; $total_q->close();
    $domain_stmt = $conn->prepare("SELECT name, url FROM domains WHERE user_id = ? AND is_active = 1 ORDER BY name ASC LIMIT ? OFFSET ?");
    $domain_stmt->bind_param("iii", $user_id, $batch_size, $offset); $domain_stmt->execute();
    $domains = $domain_stmt->get_result()->fetch_all(MYSQLI_ASSOC); $domain_stmt->close();
    if (empty($domains) && $offset == 0) { return ['text' => "Anda tidak memiliki domain aktif untuk dicek.", 'keyboard' => null]; }
    $start_num = $offset + 1; $end_num = $offset + count($domains);
    $reply = "📊 <b>Hasil Pengecekan Pantauan IPO</b>\n<i>(Menampilkan domain " . $start_num . " - " . $end_num . " dari " . $total_domains . ")</i>\n=====================\n\n";
    foreach ($domains as $domain) {
        $relay_response = checkDomainViaRelay($domain['url']);
        $reply .= "<b>" . e($domain['name']) . " (" . e($domain['url']) . ")</b>\n";
        if ($relay_response && isset($relay_response['status'])) {
            $status_text = trim(strtolower($relay_response['status'])); $status_emoji = ($status_text === "ada") ? "🔴 BLOCKED" : "🟢 SAFE"; $waktu = date('d M . H:i:s');
            foreach ($providers as $provider) { $reply .= $provider . ": " . $status_emoji . " (" . $waktu . ")\n"; }
        } else { $reply .= "⚪ ERROR saat mengecek status.\n"; }
        $reply .= "\n=====================\n\n"; usleep(200000);
    }
    $keyboard = null;
    if (($offset + $batch_size) < $total_domains) {
        $next_offset = $offset + $batch_size;
        $keyboard = [[['text' => '➡️ Lanjutkan Pengecekan (' . ($next_offset + 1) . ' dst.)', 'callback_data' => 'allstatus_' . $next_offset]]];
    } else { $reply .= "✅ Semua domain telah dicek."; }
    return ['text' => $reply, 'keyboard' => $keyboard];
}

// =======================================================
//          PROSES UTAMA WEBHOOK
// =======================================================
$update = json_decode(file_get_contents('php://input'), TRUE);

if (isset($update['callback_query'])) {
    $callbackQuery = $update['callback_query']; $chatId = $callbackQuery['message']['chat']['id']; $messageId = $callbackQuery['message']['message_id'];
    $callbackQueryId = $callbackQuery['id']; $callbackData = $callbackQuery['data'];
    $user_stmt = $conn->prepare("SELECT id FROM users WHERE telegram_chat_id = ?"); $user_stmt->bind_param("s", $chatId); $user_stmt->execute();
    $user_result = $user_stmt->get_result();
    if ($user_result->num_rows > 0) {
        $user_id = $user_result->fetch_assoc()['id']; $parts = explode('_', $callbackData, 2); $action = $parts[0]; $data = $parts[1] ?? '';
        switch ($action) {
            case 'allstatus': $offset = (int)$data; answerCallbackQuery($callbackQueryId, "Memuat batch berikutnya..."); $result = processAllStatusBatch($user_id, $offset); editMessage($chatId, $messageId, $result['text'], $result['keyboard']); break;
            case 'status': case 'refresh': $domain_url = $data; $action_text = ($action == 'status') ? "Mengambil status..." : "Merefresh..."; answerCallbackQuery($callbackQueryId, $action_text); $domain_stmt = $conn->prepare("SELECT id, name FROM domains WHERE url = ? AND user_id = ?"); $domain_stmt->bind_param("si", $domain_url, $user_id); $domain_stmt->execute(); $domain_result = $domain_stmt->get_result(); if($domain_result->num_rows > 0){ $domain_info = $domain_result->fetch_assoc(); $reply = getDomainStatusMessage($domain_info['id'], $domain_info['name'], $domain_url); $keyboard = [[['text' => '🔄 Refresh', 'callback_data' => 'refresh_' . $domain_url]]]; editMessage($chatId, $messageId, $reply, $keyboard); } break;
            case 'delete': answerCallbackQuery($callbackQueryId); $keyboard = [[['text' => '✅ Ya, Hapus', 'callback_data' => 'confirmdelete_' . $data], ['text' => '❌ Batal', 'callback_data' => 'canceldelete']]]; editMessage($chatId, $messageId, "Anda yakin ingin menghapus domain <code>" . e($data) . "</code> secara permanen?", $keyboard); break;
            case 'confirmdelete': $domain_url = $data; $delete_stmt = $conn->prepare("DELETE FROM domains WHERE url = ? AND user_id = ?"); $delete_stmt->bind_param("si", $domain_url, $user_id); if ($delete_stmt->execute() && $delete_stmt->affected_rows > 0) { answerCallbackQuery($callbackQueryId, "Domain berhasil dihapus!"); editMessage($chatId, $messageId, "✅ Domain <code>" . e($domain_url) . "</code> telah dihapus."); logActivity("User (ID: $user_id) menghapus domain via bot: $domain_url", $user_id); } else { answerCallbackQuery($callbackQueryId, "Gagal menghapus domain.", true); editMessage($chatId, $messageId, "❌ Gagal menghapus domain."); } break;
            case 'canceldelete': answerCallbackQuery($callbackQueryId); editMessage($chatId, $messageId, "Aksi penghapusan dibatalkan."); break;
        }
    } else { answerCallbackQuery($callbackQueryId, "Akses ditolak. Daftarkan Chat ID Anda.", true); }
    exit();
}

if (isset($update['message']['text'])) {
    $chatId = $update['message']['chat']['id']; $messageText = $update['message']['text']; $parts = explode(' ', $messageText, 3);
    $command_full = strtolower($parts[0]); $command = strstr($command_full, '@', true);
    if ($command === false) { $command = $command_full; }
    $arg1 = $parts[1] ?? null; $arg2 = $parts[2] ?? null;
    if ($command == '/start') { $replyKeyboard = [ [['text' => '📊 Status Domain'], ['text' => '🔄 Cek Semua Status']], [['text' => '➕ Tambah Domain'], ['text' => '🗑️ Hapus Domain']], [['text' => '🔎 Cek Domain Bebas'], ['text' => '❓ Bantuan']] ]; $pesan_selamat_datang  = "Selamat datang! 👋\n\n"; $pesan_selamat_datang .= "ID untuk chat ini adalah: <code>" . $chatId . "</code>\n\n"; $pesan_selamat_datang .= "Salin ID ini dan masukkan ke dashboard panel web Anda untuk mengaktifkan notifikasi dan perintah lainnya.\n\n"; $pesan_selamat_datang .= "Silakan pilih menu di bawah. Jika ini pertama kali, gunakan /help untuk panduan."; sendMessage($chatId, $pesan_selamat_datang, null, $replyKeyboard); logActivity("User dengan Chat ID $chatId memulai bot.", null); exit(); }
    if ($command == '/help') { sendMessage($chatId, getHelpMessage()); exit(); }
    $stmt = $conn->prepare("SELECT id, quota_total FROM users WHERE telegram_chat_id = ?"); $stmt->bind_param("s", $chatId); $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 0) { sendMessage($chatId, "❌ <b>Akses Ditolak!</b>\n\nUntuk menggunakan perintah ini, Anda harus mendaftarkan Chat ID Anda di panel web terlebih dahulu.\n\nKirim /start untuk mendapatkan ID chat ini."); exit(); }
    $user = $result->fetch_assoc(); $user_id = $user['id']; $user_quota = $user['quota_total'];
    if ($messageText === '📊 Status Domain') $command = '/status'; if ($messageText === '🔄 Cek Semua Status') $command = '/allstatus'; if ($messageText === '➕ Tambah Domain') $command = '/adddomain'; if ($messageText === '🗑️ Hapus Domain') $command = '/delete'; if ($messageText === '🔎 Cek Domain Bebas') $command = '/cek'; if ($messageText === '❓ Bantuan') $command = '/help';
    switch ($command) {
        case '/list': $domain_stmt = $conn->prepare("SELECT name, url FROM domains WHERE user_id = ? ORDER BY name ASC"); $domain_stmt->bind_param("i", $user_id); $domain_stmt->execute(); $domains = $domain_stmt->get_result(); if ($domains->num_rows > 0) { $reply = "<b>Daftar Domain Anda:</b>\n\n"; while($row = $domains->fetch_assoc()){ $reply .= "🌐 <b>" . e($row['name']) . "</b>\n   <code>" . e($row['url']) . "</code>\n\n"; } } else { $reply = "Anda belum mendaftarkan domain apapun."; } sendMessage($chatId, $reply); break;
        case '/status': case '/delete': $action = ($command == '/status') ? 'status' : 'delete'; $prompt = ($command == '/status') ? 'melihat status detailnya' : 'menghapusnya'; $domain_stmt = $conn->prepare("SELECT name, url FROM domains WHERE user_id = ? ORDER BY name ASC"); $domain_stmt->bind_param("i", $user_id); $domain_stmt->execute(); $domains = $domain_stmt->get_result(); if ($domains->num_rows > 0) { $keyboard = []; while ($domain = $domains->fetch_assoc()) { $keyboard[] = [['text' => $domain['name'] . " (" . $domain['url'] . ")", 'callback_data' => $action . '_' . $domain['url']]]; } sendMessage($chatId, "Pilih domain di bawah ini untuk " . $prompt . ":", $keyboard); } else { sendMessage($chatId, "Anda belum memiliki domain."); } break;
        case '/allstatus': $result = processAllStatusBatch($user_id, 0); sendMessage($chatId, $result['text'], $result['keyboard']); logActivity("User (ID: $user_id) menggunakan /allstatus.", $user_id); break;
        case '/cek': if (empty($arg1)) { sendMessage($chatId, "Format salah. Gunakan: <code>/cek namadomain.com</code>"); break; } $domain_to_check = trim($arg1); if (strpos($domain_to_check, 'http') === 0 || !preg_match('/^[a-zA-Z0-9-.]+(\/.*)?$/', $domain_to_check)) { sendMessage($chatId, "Format domain tidak valid. Contoh: <code>domain.com</code>"); break; } sendMessage($chatId, "🔎 Sedang mengecek status untuk <code>" . e($domain_to_check) . "</code>..."); $relay_response = checkDomainViaRelay($domain_to_check); if ($relay_response && isset($relay_response['status'])) { $status_text = trim(strtolower($relay_response['status'])); $status_emoji = ($status_text === "ada") ? "🔴 BLOCKED" : "🟢 AMAN"; $reply = "<b>Hasil Pengecekan Manual:</b>\n\n<b>Domain:</b> <code>" . e($domain_to_check) . "</code>\n<b>Status:</b> " . $status_emoji; } else { $reply = "❌ Gagal mendapatkan status."; } sendMessage($chatId, $reply); logActivity("User (ID: $user_id) melakukan cek manual untuk: $domain_to_check", $user_id); break;
        case '/adddomain': if (!$arg1 || !$arg2) { sendMessage($chatId, "Format salah. Gunakan:\n<code>/adddomain [nama] [url]</code>\n\nContoh:\n<code>/adddomain naga169 naga169.com</code>"); break; } $count_stmt = $conn->prepare("SELECT COUNT(id) as total FROM domains WHERE user_id = ?"); $count_stmt->bind_param("i", $user_id); $count_stmt->execute(); $current_domains = $count_stmt->get_result()->fetch_assoc()['total']; if($current_domains >= $user_quota){ sendMessage($chatId, "❌ Gagal! Kuota domain Anda sudah habis (".$current_domains."/".$user_quota.")."); break; } $add_stmt = $conn->prepare("INSERT INTO domains (user_id, name, url) VALUES (?, ?, ?)"); $add_stmt->bind_param("iss", $user_id, $arg1, $arg2); if($add_stmt->execute()){ sendMessage($chatId, "✅ Domain <b>".e($arg1)."</b> (<code>".e($arg2)."</code>) berhasil ditambahkan!"); logActivity("User (ID: $user_id) menambah domain via bot: $arg2.", $user_id); } else { sendMessage($chatId, "❌ Terjadi kesalahan saat menambahkan domain."); } break;
        case '/replace': if (!$arg1 || !$arg2) { sendMessage($chatId, "Format salah. Gunakan:\n<code>/replace [url_lama] [url_baru]</code>\n\nContoh:\n<code>/replace lama.com baru.com</code>"); break; } $replace_stmt = $conn->prepare("UPDATE domains SET url = ? WHERE url = ? AND user_id = ?"); $replace_stmt->bind_param("ssi", $arg2, $arg1, $user_id); $replace_stmt->execute(); if($replace_stmt->affected_rows > 0){ sendMessage($chatId, "✅ Domain <code>".e($arg1)."</code> berhasil diganti menjadi <code>".e($arg2)."</code>."); logActivity("User (ID: $user_id) mengganti domain via bot: $arg1 -> $arg2.", $user_id); } else { sendMessage($chatId, "❌ Domain lama <code>".e($arg1)."</code> tidak ditemukan di akun Anda."); } break;
        default: sendMessage($chatId, "Perintah tidak dikenali. Gunakan /help untuk melihat daftar perintah yang bisa digunakan."); break;
    }
}
$conn->close();
?>