<?php
// Memanggil file konfigurasi untuk mendapatkan nama bot
require_once 'config.php'; 
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tutorial Instalasi Bot Telegram</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .tutorial-container {
            max-width: 800px;
            margin: 2rem auto;
            padding: 2rem;
        }
        .step {
            margin-bottom: 2.5rem;
            padding-bottom: 1.5rem;
            border-bottom: 1px solid #eee;
        }
        .step:last-child {
            border-bottom: none;
        }
        .step h3 {
            font-size: 1.5rem;
            color: #d32f2f;
            margin-top: 0;
        }
        .step-content img {
            max-width: 100%;
            height: auto;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-top: 1rem;
            margin-bottom: 1rem;
        }
        .step-content code {
            background-color: #f1f1f1;
            padding: 2px 6px;
            border-radius: 4px;
            font-family: monospace;
            color: #c7254e;
        }
    </style>
</head>
<body class="dashboard">
    <div class="dashboard-container tutorial-container">
        <div class="dashboard-header" style="margin-bottom: 2rem;">
            <h2>Tutorial Menghubungkan Bot Telegram</h2>
            <a href="dashboard.php">Kembali ke Dashboard</a>
        </div>

        <div class="step">
            <h3>Langkah 1: Temukan Bot & Kirim Perintah /start</h3>
            <div class="step-content">
                <p>Buka aplikasi Telegram Anda (di HP atau Desktop), lalu cari username bot kami:</p>
                <!-- PERUBAHAN DI SINI: Memanggil variabel dari config.php -->
                <p style="text-align: center; font-size: 1.2rem;"><strong><?php echo TELEGRAM_BOT_USERNAME; ?></strong></p>
                <p>Setelah menemukan bot, klik tombol <strong>"Start"</strong> atau ketik dan kirim pesan <code>/start</code>.</p>
                <p>Bot akan langsung membalas dengan sebuah pesan yang berisi <strong>ID Chat</strong> Anda. ID ini adalah kunci untuk menghubungkan akun Anda.</p>
            </div>
        </div>

        <div class="step">
            <h3>Langkah 2: Salin (Copy) ID Chat Anda</h3>
            <div class="step-content">
                <p>ID Chat akan terlihat seperti ini (contoh):</p>
                <ul>
                    <li>Untuk chat pribadi: <code>123456789</code> (berupa angka positif)</li>
                    <li>Untuk grup: <code>-1001234567890</code> (diawali dengan tanda minus dan lebih panjang)</li>
                </ul>
                <p>Pilih dan <strong>salin (copy) seluruh ID tersebut</strong>, termasuk tanda minus jika ada.</p>
            </div>
        </div>

        <div class="step">
            <h3>Langkah 3: Tempel (Paste) ID Chat di Dashboard</h3>
            <div class="step-content">
                <p>Kembali ke halaman Dashboard panel web Anda.</p>
                <p>Cari bagian "Pengaturan Notifikasi & Bot Telegram", lalu <strong>tempelkan (paste) ID Chat</strong> yang sudah Anda salin ke dalam kolom yang tersedia.</p>
                <p><img src="https://gambarlu.com/images/2025/07/06/Screenshot_8.png" alt="Contoh menempelkan Chat ID"></p>
                <p>Terakhir, klik tombol <strong>"Simpan Chat ID"</strong>.</p>
            </div>
        </div>

        <div class="step">
            <h3>Selesai! Apa Selanjutnya?</h3>
            <div class="step-content">
                <p>Selamat! Akun Anda sekarang sudah terhubung dengan bot. Anda akan mulai menerima notifikasi jika ada perubahan status pada domain Anda.</p>
                <p>Anda juga bisa langsung berinteraksi dengan bot di Telegram menggunakan perintah-perintah berikut:</p>
                <ul>
                    <li><code>/list</code> - Untuk melihat daftar domain Anda.</li>
                    <li><code>/adddomain [nama] [url]</code> - Untuk menambah domain baru.</li>
                    <li><code>/replace [url_lama] [url_baru]</code> - Mengganti URL domain lama.</li>
                    <li><code>/help</code> - Untuk melihat kembali daftar perintah ini.</li>
                </ul>
            </div>
        </div>

    </div>
</body>
</html>