<?php 
// file: /public_html/transactions.php

// Menentukan judul halaman untuk ditampilkan di header
$current_page_title = "Transactions";
// Memanggil template header
require_once 'layout_header.php'; 

// Mengambil data log aktivitas yang relevan untuk pengguna yang sedang login
// Kita mencari log yang dibuat oleh admin (user_id IS NULL atau role admin) atau log milik user itu sendiri
// yang mengandung kata kunci paket/kuota.
$stmt = $conn->prepare("
    SELECT action, created_at 
    FROM activity_logs 
    WHERE 
        user_id = ? 
        AND (
            action LIKE '%paket%' OR 
            action LIKE '%kuota%' OR 
            action LIKE '%downgrade%' OR
            action LIKE '%mengupdate user%' 
        )
    ORDER BY id DESC
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$transactions = $stmt->get_result();
?>

<!-- CSS khusus untuk halaman ini agar terlihat lebih baik -->
<style>
    .transaction-icon {
        font-size: 1.5rem;
        margin-right: 15px;
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        border-radius: 50%;
    }
    .transaction-item {
        display: flex;
        align-items: center;
        padding: 1rem 0;
        border-bottom: 1px solid #f1f1f1;
    }
    .transaction-item:last-child {
        border-bottom: none;
    }
    .transaction-details p {
        margin-bottom: 0;
    }
</style>

<div class="container-fluid">
    <!-- Header Halaman -->
    <h1 class="mt-4">Riwayat Transaksi & Paket</h1>
    <p class="lead">Berikut adalah riwayat perubahan paket dan kuota untuk akun Anda.</p>
    
    <!-- Konten Utama -->
    <div class="card mt-4">
        <div class="card-header fw-bold">
            Riwayat Aktivitas Paket
        </div>
        <div class="card-body">
            <?php if ($transactions->num_rows > 0): ?>
                <div class="list-group list-group-flush">
                    <?php while($row = $transactions->fetch_assoc()): ?>
                        <div class="transaction-item">
                            <div class="transaction-icon bg-light text-primary">
                                <i class="fas fa-file-invoice-dollar"></i>
                            </div>
                            <div class="transaction-details">
                                <p class="fw-bold mb-1">
                                    <?php 
                                        // Membersihkan pesan log agar lebih ramah dibaca
                                        $action_text = str_replace("Admin (ID: $admin_id) ", "", $row['action']);
                                        $action_text = str_replace("user ID: $user_id", "akun Anda", $action_text);
                                        echo e(ucfirst($action_text)); 
                                    ?>
                                </p>
                                <small class="text-muted">
                                    <i class="far fa-clock"></i> <?php echo date('d F Y, H:i', strtotime($row['created_at'])); ?>
                                </small>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php else: ?>
                <p class="text-center p-4">Belum ada riwayat transaksi atau perubahan paket yang tercatat untuk akun Anda.</p>
            <?php endif; ?>
        </div>
    </div>

</div> <!-- /container-fluid -->

<?php 
// Memanggil template footer
require_once 'layout_footer.php'; 
?>