<?php
require_once 'config.php';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $contact = trim($_POST['contact']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    if (empty($contact) || empty($email) || empty($password)) { header("Location: register.php?error=Semua field wajib diisi."); exit(); }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { header("Location: register.php?error=Format email tidak valid."); exit(); }
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute(); $stmt->store_result();
    if ($stmt->num_rows > 0) { header("Location: register.php?error=Email sudah terdaftar."); exit(); }
    $stmt->close();
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $pkg_q = $conn->query("SELECT quota FROM packages WHERE id = 1");
    $default_quota = $pkg_q->num_rows > 0 ? $pkg_q->fetch_assoc()['quota'] : 1;
    $stmt = $conn->prepare("INSERT INTO users (contact, email, password, package_id, quota_total) VALUES (?, ?, ?, 1, ?)");
    $stmt->bind_param("sssi", $contact, $email, $hashed_password, $default_quota);
    if ($stmt->execute()) {
        $new_user_id = $stmt->insert_id;
        logActivity("User baru mendaftar: $email", $new_user_id);
        header("Location: login.php?success=Registrasi berhasil. Akun Anda aktif dengan paket percobaan.");
    } else { header("Location: register.php?error=Terjadi kesalahan server."); }
    $stmt->close(); $conn->close();
} else { header("Location: register.php"); exit(); }
?>