<?php
require_once 'config.php';
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
$user_id = $_SESSION['user_id'];
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    $action = $_POST['action'];
    if ($action == 'update_info') {
        $contact = trim($_POST['contact']);
        $stmt = $conn->prepare("UPDATE users SET contact = ? WHERE id = ?");
        $stmt->bind_param("si", $contact, $user_id);
        if($stmt->execute()) logActivity("User mengubah info kontak.", $user_id);
        header("Location: profile.php?status=success"); exit();
    }
    if ($action == 'update_password') {
        $current_pass = $_POST['current_password']; $new_pass = $_POST['new_password']; $confirm_pass = $_POST['confirm_password'];
        if(strlen($new_pass) < 6) { header("Location: profile.php?error=Password baru minimal 6 karakter."); exit(); }
        if($new_pass !== $confirm_pass) { header("Location: profile.php?error=Konfirmasi password baru tidak cocok."); exit(); }
        $stmt = $conn->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->bind_param("i", $user_id); $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();
        if ($user && password_verify($current_pass, $user['password'])) {
            $hashed_password = password_hash($new_pass, PASSWORD_DEFAULT);
            $update_stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            $update_stmt->bind_param("si", $hashed_password, $user_id);
            if($update_stmt->execute()) logActivity("User mengubah password.", $user_id);
            header("Location: profile.php?status=success"); exit();
        } else { header("Location: profile.php?error=Password saat ini salah."); exit(); }
    }
}
header("Location: profile.php"); exit();
?>