<?php
require_once 'config.php';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    if (empty($email) || empty($password)) { header("Location: login.php?error=Email dan password harus diisi."); exit(); }
    $stmt = $conn->prepare("SELECT id, password, role FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_role'] = $user['role'];
            logActivity("User login.", $user['id']);
            header("Location: dashboard.php");
            exit();
        } else {
            logActivity("Gagal login (password salah) untuk email: $email");
            header("Location: login.php?error=Password salah.");
            exit();
        }
    } else {
        header("Location: login.php?error=Email tidak ditemukan.");
        exit();
    }
} else { header("Location: login.php"); exit(); }
?>