<?php
require_once 'config.php';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $user = $result->fetch_assoc();
        $token = bin2hex(random_bytes(50));
        $expires = date("Y-m-d H:i:s", time() + 3600); // Token valid 1 jam
        $update_stmt = $conn->prepare("UPDATE users SET reset_token = ?, reset_token_expires = ? WHERE id = ?");
        $update_stmt->bind_param("ssi", $token, $expires, $user['id']);
        $update_stmt->execute();
        $reset_link = "https://bestdefends588.com/reset_password.php?token=" . $token; // GANTI DOMAIN
        $subject = "Reset Password untuk Akun Anda";
        $message = "Klik link berikut untuk mereset password Anda: " . $reset_link;
        $headers = "From: no-reply@domainanda.com"; // GANTI EMAIL
        if (mail($email, $subject, $message, $headers)) {
            logActivity("User $email meminta reset password.");
            header("Location: forgot_password.php?msg=Link reset telah dikirim ke email Anda.");
        } else {
            header("Location: forgot_password.php?error=Gagal mengirim email. Hubungi admin.");
        }
    } else {
        header("Location: forgot_password.php?error=Email tidak ditemukan.");
    }
}
?>