<?php
require_once 'config.php';
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
$user_id = $_SESSION['user_id'];

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    $action = $_POST['action'];
    
    if ($action == 'add_dynamic_bulk') {
        if (!isset($_POST['domain_name']) || !is_array($_POST['domain_name'])) { header("Location: dashboard.php?error=Data tidak valid."); exit(); }
        $domain_names = $_POST['domain_name']; $domain_urls = $_POST['domain_url'];
        $quota_stmt = $conn->prepare("SELECT quota_total FROM users WHERE id = ?");
        $quota_stmt->bind_param("i", $user_id); $quota_stmt->execute();
        $user_quota = $quota_stmt->get_result()->fetch_assoc()['quota_total'];
        $count_stmt = $conn->prepare("SELECT COUNT(id) as total FROM domains WHERE user_id = ?");
        $count_stmt->bind_param("i", $user_id); $count_stmt->execute();
        $current_domains = $count_stmt->get_result()->fetch_assoc()['total'];
        $quota_remaining = $user_quota - $current_domains;
        $sql_values = []; $params_to_bind = []; $types = "";
        foreach ($domain_names as $index => $name) {
            if ($quota_remaining <= 0) break;
            if (!isset($domain_urls[$index])) continue;
            $url = trim($domain_urls[$index]); $name = trim($name);
            if (empty($name) || empty($url) || strpos($url, 'http') === 0 || !preg_match('/^[a-zA-Z0-9-.]+(\/.*)?$/', $url)) { continue; }
            $sql_values[] = "(?, ?, ?)";
            $params_to_bind[] = $user_id; $params_to_bind[] = $name; $params_to_bind[] = $url;
            $types .= "iss";
            $quota_remaining--;
        }
        if (!empty($sql_values)) {
            $sql = "INSERT INTO domains (user_id, name, url) VALUES " . implode(", ", $sql_values);
            $stmt = $conn->prepare($sql);
            $stmt->bind_param($types, ...$params_to_bind);
            if ($stmt->execute()) {
                $added_count = $stmt->affected_rows;
                logActivity("Menambahkan $added_count domain via bulk.", $user_id);
                header("Location: dashboard.php?success_add=" . urlencode("$added_count domain berhasil ditambahkan."));
            } else { header("Location: dashboard.php?error=Terjadi kesalahan saat menyimpan data."); }
            exit();
        } else { header("Location: dashboard.php?error=Tidak ada data valid untuk ditambahkan."); exit(); }

    } elseif ($action == 'delete') {
        $domain_id = (int)$_POST['domain_id'];
        $can_delete = false;
        if (isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'admin') {
            $can_delete = true;
        } else {
            $check_owner_q = $conn->prepare("SELECT id FROM domains WHERE id = ? AND user_id = ?");
            $check_owner_q->bind_param("ii", $domain_id, $user_id);
            $check_owner_q->execute();
            if ($check_owner_q->get_result()->num_rows > 0) $can_delete = true;
        }
        if ($can_delete) {
            $stmt = $conn->prepare("DELETE FROM domains WHERE id = ?");
            $stmt->bind_param("i", $domain_id);
            if($stmt->execute()) logActivity("Menghapus domain ID: $domain_id oleh User ID: $user_id", $user_id);
        }

    } elseif ($action == 'toggle') {
        $domain_id = (int)$_POST['domain_id'];
        $stmt = $conn->prepare("UPDATE domains SET is_active = NOT is_active WHERE id = ? AND user_id = ?");
        $stmt->bind_param("ii", $domain_id, $user_id);
        if($stmt->execute()) logActivity("Mengubah status aktifasi domain ID: $domain_id", $user_id);
    
    } elseif ($action == 'update' && isset($_POST['domain_id'])) {
        $domain_id = (int)$_POST['domain_id']; $name = trim($_POST['name']); $url = trim($_POST['url']);
        if (empty($name) || empty($url)) { header("Location: edit_domain.php?id={$domain_id}&error=Nama dan URL tidak boleh kosong"); exit(); }
        $can_update = false;
        if (isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'admin') {
            $can_update = true;
        } else {
            $check_owner_q = $conn->prepare("SELECT id FROM domains WHERE id = ? AND user_id = ?");
            $check_owner_q->bind_param("ii", $domain_id, $user_id);
            $check_owner_q->execute();
            if ($check_owner_q->get_result()->num_rows > 0) $can_update = true;
        }
        if ($can_update) {
            $stmt = $conn->prepare("UPDATE domains SET name = ?, url = ? WHERE id = ?");
            $stmt->bind_param("ssi", $name, $url, $domain_id);
            if($stmt->execute()) logActivity("Mengedit domain ID: $domain_id oleh User ID: $user_id menjadi $url", $user_id);
        }
    }
}
if (isset($_POST['ref']) && $_POST['ref'] == 'admin' && isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'admin') {
    header("Location: admin/manage_domains.php");
} else {
    header("Location: dashboard.php");
}
exit();
?>