<?php
// file: /public_html/layout_header.php
require_once 'config.php';
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
$user_id = $_SESSION['user_id'];
// PERBAIKAN: Cek apakah user ada sebelum digunakan
$user_stmt = $conn->prepare("SELECT email FROM users WHERE id = ?");
$user_stmt->bind_param("i", $user_id);
$user_stmt->execute();
$user_res = $user_stmt->get_result();
if ($user_res->num_rows === 0) {
    // Sesi "hantu", hancurkan dan paksa login ulang
    session_unset();
    session_destroy();
    header("Location: login.php?error=Sesi+tidak+valid.+Silakan+login+kembali.");
    exit();
}
$user_email = $user_res->fetch_assoc()['email'];
$user_stmt->close();
// Untuk menandai menu aktif
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($current_page_title) ? e($current_page_title) . ' - ' : ''; ?>Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
    <link rel="stylesheet" href="assets/css/custom-style.css">
</head>
<body>
<div id="wrapper">
    <!-- Sidebar -->
    <div id="sidebar-wrapper">
        <div class="sidebar-heading">BestDefend588</div>
        <div class="list-group list-group-flush">
            <div class="main-menu-heading">Main Menu</div>
            <a href="transactions.php" class="nav-link <?php if ($current_page == 'transactions.php') echo 'active'; ?>">
                <i class="fas fa-exchange-alt"></i> Transactions
            </a>
            <a href="dashboard.php" class="nav-link <?php if ($current_page == 'dashboard.php') echo 'active'; ?>">
                <i class="fas fa-globe"></i> Websites
            </a>
            <a href="customer_service.php" class="nav-link <?php if ($current_page == 'customer_service.php') echo 'active'; ?>">
                <i class="fas fa-headset"></i> Customer Service
            </a>
            <div class="main-menu-heading" style="margin-top:1rem;">Settings</div>
            <a href="profile.php" class="nav-link <?php if ($current_page == 'profile.php') echo 'active'; ?>">
                <i class="fas fa-user-cog"></i> Profile Setting
            </a>
        </div>
        <div class="sidebar-footer">
            <div class="d-flex align-items-center">
                <div class="me-2" style="background-color:#0d6efd; color:white; width:40px; height:40px; border-radius:50%; display:flex; align-items:center; justify-content:center; font-weight:bold; text-transform:uppercase;">
                    <?php echo substr(explode('@', $user_email)[0], 0, 1); ?>
                </div>
                <div class="flex-grow-1">
                    <div style="font-weight:bold; font-size:0.9rem;"><?php echo e(explode('@', $user_email)[0]); ?></div>
                    <small class="text-muted">User</small>
                </div>
                <a href="logout.php" title="Logout" class="ms-2"><i class="fas fa-power-off text-danger fs-5"></i></a>
            </div>
        </div>
    </div>
    <main id="page-content-wrapper">