<?php
require_once 'config.php';
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit(); }
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) { header("Location: dashboard.php"); exit(); }
$user_id = $_SESSION['user_id'];
$domain_id = (int)$_GET['id'];
$ref_from = $_GET['ref'] ?? 'user';
$can_edit = false;
if (isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'admin') { $can_edit = true; }
if ($can_edit) {
    $stmt = $conn->prepare("SELECT name, url FROM domains WHERE id = ?");
    $stmt->bind_param("i", $domain_id);
} else {
    $stmt = $conn->prepare("SELECT name, url FROM domains WHERE id = ? AND user_id = ?");
    $stmt->bind_param("ii", $domain_id, $user_id);
}
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) { die("Akses ditolak atau domain tidak ditemukan."); }
$domain = $result->fetch_assoc(); $stmt->close();
$current_page_title = "Edit Domain";
require_once 'layout_header.php';
?>
<div class="container-fluid">
<h1 class="mt-4">Edit Domain: <?php echo e($domain['name']); ?></h1>
<div class="card"><div class="card-body">
<form action="process_domain.php" method="POST">
    <input type="hidden" name="action" value="update"><input type="hidden" name="domain_id" value="<?php echo $domain_id; ?>"><input type="hidden" name="ref" value="<?php echo e($ref_from); ?>">
    <div class="mb-3"><label class="form-label">Nama Alias</label><input type="text" name="name" class="form-control" value="<?php echo e($domain['name']); ?>" required></div>
    <div class="mb-3"><label class="form-label">URL Domain</label><input type="text" name="url" class="form-control" value="<?php echo e($domain['url']); ?>" required></div>
    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
    <a href="<?php echo ($ref_from == 'admin') ? 'admin/manage_domains.php' : 'dashboard.php'; ?>" class="btn btn-secondary">Batal</a>
</form>
</div></div></div>
<?php require_once 'layout_footer.php'; ?>