<?php
// file: /public_html/dashboard.php (Versi Final Utuh dengan Perbaikan JS & Layout)

$current_page_title = "Websites"; 
require_once 'layout_header.php'; 

// --- PENGAMBILAN DATA (Sudah termasuk perbaikan error sesi dari header) ---
// Ambil semua data user yang relevan dalam satu query
$user_stmt = $conn->prepare("SELECT u.telegram_chat_id, p.name as package_name, u.quota_total, u.trial_expires_at FROM users u LEFT JOIN packages p ON u.package_id = p.id WHERE u.id = ?");
$user_stmt->bind_param("i", $user_id);
$user_stmt->execute();
$user_result = $user_stmt->get_result()->fetch_assoc();

$trial_expires = $user_result['trial_expires_at'] ?? null;
$user_package = $user_result['package_name'] ?? 'N/A';
$user_quota_total = $user_result['quota_total'] ?? 0;

// Ambil semua data domain dan statusnya
$domain_stmt = $conn->prepare("SELECT d.id, d.name, d.url, d.is_active, ds.provider, ds.status, ds.last_checked FROM domains d LEFT JOIN domain_statuses ds ON d.id = ds.domain_id WHERE d.user_id = ? ORDER BY d.id");
$domain_stmt->bind_param("i", $user_id);
$domain_stmt->execute();
$results = $domain_stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Proses dan kelompokkan data untuk ditampilkan
$domains = [];
foreach ($results as $row) {
    $domain_id = $row['id'];
    if (!isset($domains[$domain_id])) {
        $domains[$domain_id] = [
            'name' => $row['name'],
            'url' => $row['url'],
            'is_active' => $row['is_active'],
            'statuses' => []
        ];
    }
    if ($row['provider']) {
        $domains[$domain_id]['statuses'][$row['provider']] = [
            'status' => $row['status'],
            'last_checked' => $row['last_checked']
        ];
    }
}
$total_domain = count($domains);
$quota_remaining = $user_quota_total - $total_domain;
if ($quota_remaining < 0) {
    $quota_remaining = 0;
}
?>

<div class="container-fluid">
    <h1 class="mt-4"><?php echo e($current_page_title); ?></h1>
    <nav aria-label="breadcrumb"><ol class="breadcrumb bg-light p-2 rounded-2"><li class="breadcrumb-item"><a href="dashboard.php">Main Menu</a></li><li class="breadcrumb-item active" aria-current="page"><?php echo e($current_page_title); ?></li></ol></nav>
    
    <!-- Notifikasi -->
    <?php if ($trial_expires): ?><div class="alert alert-info">Paket Percobaan Anda akan berakhir pada: <strong><?php echo date('d F Y, H:i', strtotime($trial_expires)); ?></strong>. Hubungi admin untuk upgrade.</div><?php endif; ?>
    <?php if (isset($_GET['error'])): ?><div class="alert alert-danger"><?php echo e($_GET['error']); ?></div><?php endif; ?>
    <?php if (isset($_GET['success_add'])): ?><div class="alert alert-success"><?php echo e($_GET['success_add']); ?></div><?php endif; ?>
    <?php if (isset($_GET['notif_status']) && $_GET['notif_status'] == 'success'): ?><div class="alert alert-success">Chat ID berhasil diperbarui!</div><?php endif; ?>

    <!-- Kartu Ringkasan Statistik -->
    <div class="row">
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card text-dark bg-light h-100">
                <div class="card-body">
                    <h5 class="card-title text-secondary">Total Domain</h5>
                    <p class="card-text fs-1 fw-bold"><?php echo $total_domain; ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card text-dark bg-light h-100">
                <div class="card-body">
                    <h5 class="card-title text-secondary">Total Kuota</h5>
                    <p class="card-text fs-1 fw-bold"><?php echo $user_quota_total; ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card text-dark bg-light h-100">
                <div class="card-body">
                    <h5 class="card-title text-secondary">Sisa Kuota</h5>
                    <p class="card-text fs-1 fw-bold"><?php echo $quota_remaining; ?></p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card text-white bg-primary h-100">
                <div class="card-body">
                    <h5 class="card-title">Paket Anda</h5>
                    <p class="card-text fs-3"><?php echo e($user_package); ?></p>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Form Pengaturan Chat ID -->
    <div class="card mt-2">
        <div class="card-header fw-bold">Pengaturan Notifikasi Telegram</div>
        <div class="card-body">
            <p class="card-text text-muted" style="font-size: 0.9rem;">Hubungkan akun Anda dengan bot untuk menerima notifikasi. Bingung? Lihat <strong><a href="tutorial.php" target="_blank">Tutorial Lengkap</a></strong>.</p>
            <form action="process_settings.php" method="POST">
                <div class="input-group">
                    <span class="input-group-text"><i class="fab fa-telegram-plane"></i></span>
                    <input type="text" id="chat_id" name="chat_id" class="form-control" placeholder="Masukkan Chat ID Anda" value="<?php echo e($user_result['telegram_chat_id'] ?? ''); ?>" required>
                    <button type="submit" class="btn btn-primary">Simpan Chat ID</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabel Domain -->
    <div class="card mt-4">
        <div class="card-header fw-bold">Your Websites</div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-6"><input type="text" id="domainSearch" class="form-control" placeholder="Cari berdasarkan nama atau URL..."></div>
                <div class="col-md-6 text-end">
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-sm btn-outline-secondary filter-btn active" data-filter="all">Semua</button>
                        <button type="button" class="btn btn-sm btn-outline-success filter-btn" data-filter="safe">Aman</button>
                        <button type="button" class="btn btn-sm btn-outline-danger filter-btn" data-filter="blocked">Terblokir</button>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped table-hover align-middle" id="domainTable">
                    <thead>
                        <tr><th style="width: 20%;">Nama</th><th style="width: 30%;">URL</th><th style="width: 10%;">Aktif</th><th style="width: 25%;">Status</th><th style="width: 15%; text-align: right;">Aksi</th></tr>
                    </thead>
                    <tbody>
                        <?php if (empty($domains)): ?>
                            <tr><td colspan="5" class="text-center p-4">Anda belum menambahkan domain.</td></tr>
                        <?php else: ?>
                            <?php foreach ($domains as $id => $domain): ?>
                                <?php
                                $is_any_blocked = false;
                                if (!empty($domain['statuses'])) {
                                    foreach($domain['statuses'] as $s) {
                                        if($s['status'] == 'BLOCKED') {
                                            $is_any_blocked = true;
                                            break;
                                        }
                                    }
                                }
                                $row_status = (empty($domain['statuses'])) ? 'pending' : ($is_any_blocked ? 'blocked' : 'safe');
                                ?>
                                <tr data-status="<?php echo $row_status; ?>">
                                    <td><?php echo e($domain['name']); ?></td>
                                    <td><code><?php echo e($domain['url']); ?></code></td>
                                    <td>
                                        <form action="process_domain.php" method="POST" style="margin:0;">
                                            <input type="hidden" name="action" value="toggle">
                                            <input type="hidden" name="domain_id" value="<?php echo $id; ?>">
                                            <button type="submit" class="btn btn-sm <?php echo $domain['is_active'] ? 'btn-success' : 'btn-secondary'; ?>"><?php echo $domain['is_active'] ? 'ON' : 'OFF'; ?></button>
                                        </form>
                                    </td>
                                    <td>
                                        <?php echo ($row_status == 'pending') ? '<span class="badge bg-warning text-dark">PENDING</span>' : ($is_any_blocked ? '<span class="badge bg-danger">BLOCKED</span>' : '<span class="badge bg-success">AMAN</span>'); ?>
                                        <button class="view-details-btn" data-domain-id="<?php echo $id; ?>">Detail</button>
                                    </td>
                                    <td class="action-links text-end">
                                        <a href="edit_domain.php?id=<?php echo $id; ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                                        <form action="process_domain.php" method="POST" style="display:inline;" onsubmit="return confirm('Anda yakin?');">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="domain_id" value="<?php echo $id; ?>">
                                            <button type="submit" class="btn btn-sm btn-outline-danger">Hapus</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Form Tambah Domain -->
    <div class="card mt-4">
        <div class="card-header fw-bold">Tambah Domain Baru</div>
        <div class="card-body">
            <?php if ($quota_remaining > 0): ?>
                <form action="process_domain.php" method="POST" id="bulk-add-form">
                    <input type="hidden" name="action" value="add_dynamic_bulk">
                    <div id="domain-input-container">
                        <div class="domain-input-row" style="display: flex; gap: 1rem; margin-bottom: 0.5rem; align-items: center;">
                            <input type="text" name="domain_name[]" placeholder="Nama Alias" class="form-control" required>
                            <input type="text" name="domain_url[]" placeholder="URL Domain (tanpa http://)" class="form-control" required>
                            <button type="button" class="remove-row-btn btn btn-danger" style="display:none;">X</button>
                        </div>
                    </div>
                    <div style="margin-top: 1rem; display: flex; justify-content: space-between; align-items: center;">
                        <button type="button" id="add-row-btn" class="btn btn-success">[+] Tambah Baris</button>
                        <button type="submit" class="btn btn-primary fw-bold">Tambah Semua Domain</button>
                    </div>
                    <p class="form-text">Anda bisa menambahkan hingga <strong><?php echo $quota_remaining; ?></strong> domain lagi.</p>
                </form>
            <?php else: ?>
                <div class="alert alert-warning">Kuota domain Anda sudah habis. Hapus domain lama atau hubungi admin.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div id="statusModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 id="modalTitle">Detail Status Provider</h3>
            <span class="close-btn">×</span>
        </div>
        <div id="modalBody"></div>
    </div>
</div>
<div id="all-domain-statuses" style="display:none;"><?php echo json_encode($domains); ?></div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('statusModal');
    const modalTitle = document.getElementById('modalTitle');
    const modalBody = document.getElementById('modalBody');
    const closeBtn = document.querySelector('.close-btn');
    const allStatuses = JSON.parse(document.getElementById('all-domain-statuses').textContent);
    const providerList = <?php echo json_encode($providers); ?>;

    document.querySelectorAll('.view-details-btn').forEach(button => {
        button.addEventListener('click', function() {
            const domainId = this.getAttribute('data-domain-id');
            const domainData = allStatuses[domainId];
            if (domainData) {
                modalTitle.textContent = 'Detail Status untuk ' + domainData.name;
                let content = '<ul class="status-list">';
                if (Object.keys(domainData.statuses).length > 0) {
                    for (const provider of providerList) {
                        const statusInfo = domainData.statuses[provider];
                        let statusText = 'PENDING';
                        let badgeClass = 'bg-warning text-dark';
                        if (statusInfo) {
                            statusText = statusInfo.status.toUpperCase();
                            if (statusText === 'SAFE') { badgeClass = 'bg-success text-white'; } 
                            else if (statusText === 'BLOCKED') { badgeClass = 'bg-danger text-white'; } 
                            else if (statusText === 'ERROR') { badgeClass = 'bg-secondary text-white'; }
                        }
                        content += `<li>${provider} <span class="badge ${badgeClass}">${statusText}</span></li>`;
                    }
                } else {
                    content += '<li>Status masih menunggu pengecekan pertama.</li>';
                }
                content += '</ul>';
                modalBody.innerHTML = content;
                modal.style.display = 'flex';
            }
        });
    });

    if (closeBtn) {
        closeBtn.onclick = function() { modal.style.display = 'none'; }
    }
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    }

    const addBtn = document.getElementById('add-row-btn');
    if (addBtn) {
        addBtn.addEventListener('click', function() {
            const container = document.getElementById('domain-input-container');
            const firstRow = container.querySelector('.domain-input-row');
            const newRow = firstRow.cloneNode(true);
            newRow.querySelector('input[name="domain_name[]"]').value = "";
            newRow.querySelector('input[name="domain_url[]"]').value = "";
            newRow.querySelector('.remove-row-btn').style.display = "inline-block";
            container.appendChild(newRow);
        });
    }

    const domainContainer = document.getElementById('domain-input-container');
    if (domainContainer) {
        domainContainer.addEventListener('click', function(e) {
            if (e.target && e.target.classList.contains('remove-row-btn')) {
                e.target.closest('.domain-input-row').remove();
            }
        });
    }

    const searchInput = document.getElementById('domainSearch');
    if (searchInput) {
        searchInput.addEventListener('keyup', function() {
            const filter = this.value.toUpperCase();
            const table = document.getElementById('domainTable');
            const tr = table.getElementsByTagName('tr');
            for (let i = 1; i < tr.length; i++) {
                let tdName = tr[i].getElementsByTagName('td')[0];
                let tdUrl = tr[i].getElementsByTagName('td')[1];
                if (tdName && tdUrl) {
                    let txtValue = (tdName.textContent || tdName.innerText) + (tdUrl.textContent || tdUrl.innerText);
                    tr[i].style.display = (txtValue.toUpperCase().indexOf(filter) > -1) ? "" : "none";
                }
            }
        });
    }
    
    document.querySelectorAll('.filter-btn').forEach(button => {
        button.addEventListener('click', function() {
            document.querySelectorAll('.filter-btn').forEach(btn => btn.classList.remove('active'));
            this.classList.add('active');
            const filter = this.getAttribute('data-filter');
            const table = document.getElementById('domainTable');
            const tr = table.getElementsByTagName('tr');
            for (let i = 1; i < tr.length; i++) {
                const rowStatus = tr[i].getAttribute('data-status');
                tr[i].style.display = (filter === 'all' || filter === rowStatus) ? "" : "none";
            }
        });
    });
});
</script>

<?php require_once 'layout_footer.php'; ?>