<?php 
// file: /public_html/customer_service.php

// Menentukan judul halaman untuk ditampilkan di header
$current_page_title = "Customer Service";
// Memanggil template header
require_once 'layout_header.php'; 
?>

<!-- CSS khusus untuk halaman ini agar tombol terlihat lebih baik -->
<style>
    .cs-card {
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }
    .cs-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15)!important;
    }
    .cs-icon {
        font-size: 3rem; /* 48px */
        margin-bottom: 1rem;
    }
    .btn-cs {
        font-size: 1.1rem;
        font-weight: bold;
        padding: 0.75rem 1.5rem;
    }
</style>

<div class="container-fluid">
    <!-- Header Halaman -->
    <h1 class="mt-4">Customer Service</h1>
    <p class="lead">Kami siap membantu Anda. Silakan pilih salah satu metode di bawah ini untuk menghubungi kami.</p>
    <hr class="my-4">

    <!-- Konten Utama dengan Kartu Pilihan -->
    <div class="row text-center">

        <!-- Opsi 1: Hubungi via Telegram -->
        <div class="col-lg-6 mb-4">
            <div class="card h-100 shadow-sm cs-card">
                <div class="card-body d-flex flex-column justify-content-center">
                    <div class="cs-icon text-primary">
                        <i class="fab fa-telegram-plane"></i>
                    </div>
                    <h4 class="card-title">Hubungi via Telegram</h4>
                    <p class="card-text">Pilihan terbaik untuk respons cepat dan dukungan teknis. Klik tombol di bawah untuk langsung membuka chat.</p>
                    <div class="mt-auto">
                        <a href="https://t.me/cosa_nostra169" target="_blank" class="btn btn-primary btn-cs">
                            Chat di Telegram
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Opsi 2: Hubungi via WhatsApp -->
        <div class="col-lg-6 mb-4">
            <div class="card h-100 shadow-sm cs-card">
                <div class="card-body d-flex flex-column justify-content-center">
                    <div class="cs-icon" style="color: #25D366;">
                        <i class="fab fa-whatsapp"></i>
                    </div>
                    <h4 class="card-title">Hubungi via WhatsApp</h4>
                    <p class="card-text">Hubungi kami melalui WhatsApp untuk pertanyaan umum atau informasi layanan lainnya.</p>
                    <div class="mt-auto">
                        <a href="https://wa.me/6287719072748" target="_blank" class="btn btn-success btn-cs">
                            Chat di WhatsApp
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div> <!-- /row -->

</div> <!-- /container-fluid -->

<?php 
// Memanggil template footer
require_once 'layout_footer.php'; 
?>