<?php
// file: /public_html/check_trials.php (Versi Final dengan Nonaktifkan Domain)

// Set agar skrip tidak timeout dan berjalan dari direktori yang benar
set_time_limit(0);
chdir(__DIR__);
require_once 'config.php';

logActivity("Cron Job: Memulai pengecekan masa percobaan yang kedaluwarsa.");
echo "Cron Job: Memulai pengecekan masa percobaan...\n";

// Ambil pengaturan dari database: paket apa yang akan diberikan setelah trial habis
$settings_q = $conn->query("SELECT setting_value FROM settings WHERE setting_name = 'default_package_after_trial'");
// Jika tidak ada di DB, gunakan paket ID 2 (Basic) sebagai default
$package_after_trial_id = $settings_q->fetch_assoc()['setting_value'] ?? 2;

// Ambil kuota dari paket baru tersebut
$pkg_q = $conn->prepare("SELECT quota FROM packages WHERE id = ?");
$pkg_q->bind_param("i", $package_after_trial_id);
$pkg_q->execute();
$new_quota_res = $pkg_q->get_result();
// Jika paket tidak ditemukan, gunakan kuota 5 sebagai default aman
$new_quota = $new_quota_res->num_rows > 0 ? $new_quota_res->fetch_assoc()['quota'] : 5;
$pkg_q->close();

// Cari semua pengguna yang masa percobaannya sudah lewat
$expired_users_q = $conn->query("SELECT id, email FROM users WHERE trial_expires_at IS NOT NULL AND trial_expires_at < NOW()");

if ($expired_users_q && $expired_users_q->num_rows > 0) {
    $num_expired = $expired_users_q->num_rows;
    logActivity("Cron Job: Ditemukan $num_expired pengguna dengan masa percobaan habis.");
    echo "Ditemukan $num_expired pengguna yang masa percobaannya habis. Memproses...\n";
    
    // Siapkan query untuk update paket (downgrade) pengguna
    $update_user_stmt = $conn->prepare("UPDATE users SET package_id = ?, quota_total = ?, trial_expires_at = NULL WHERE id = ?");
    $update_user_stmt->bind_param("iii", $package_after_trial_id, $new_quota, $user_id_to_update);

    // ====================================================================
    //          PERUBAHAN UTAMA ADA DI SINI
    // ====================================================================
    // Siapkan query untuk menonaktifkan semua domain milik user
    $deactivate_domains_stmt = $conn->prepare("UPDATE domains SET is_active = 0 WHERE user_id = ?");
    $deactivate_domains_stmt->bind_param("i", $user_id_to_update);
    // ====================================================================

    while ($user = $expired_users_q->fetch_assoc()) {
        $user_id_to_update = $user['id'];
        $user_email = $user['email'];
        
        // 1. Nonaktifkan semua domain milik pengguna ini terlebih dahulu
        $deactivate_domains_stmt->execute();
        $domains_affected = $deactivate_domains_stmt->affected_rows;
        if ($domains_affected > 0) {
            $log_deactivate = "Cron Job: Menonaktifkan $domains_affected domain milik $user_email karena trial habis.";
            logActivity($log_deactivate, $user_id_to_update);
            echo $log_deactivate . "\n";
        }

        // 2. Baru kemudian downgrade paket pengguna
        if ($update_user_stmt->execute()) {
            $log_downgrade = "Cron Job: Pengguna $user_email (ID: $user_id_to_update) di-downgrade ke paket ID $package_after_trial_id.";
            logActivity($log_downgrade, $user_id_to_update);
            echo $log_downgrade . "\n";
        }
    }
    $update_user_stmt->close();
    $deactivate_domains_stmt->close();
} else {
    logActivity("Cron Job: Tidak ada pengguna dengan masa percobaan habis.");
    echo "Tidak ada pengguna yang masa percobaannya habis.\n";
}

$conn->close();
echo "Pengecekan masa percobaan selesai.\n";
?>