<?php 
// file: /public_html/admin/settings.php (File Baru & Final)

require_once 'header.php'; // Memanggil header yang sudah ada

// Ambil semua pengaturan saat ini dari database untuk ditampilkan di form
$settings_q = $conn->query("SELECT * FROM settings");
$settings = [];
while ($row = $settings_q->fetch_assoc()) {
    $settings[$row['setting_name']] = $row['setting_value'];
}

// Ambil semua paket yang tersedia untuk ditampilkan di dropdown pilihan
$packages_q = $conn->query("SELECT id, name FROM packages");

// Ambil data untuk ringkasan di dashboard admin
$total_users_q = $conn->query("SELECT COUNT(id) FROM users");
$total_users = $total_users_q->fetch_row()[0];
$total_domains_q = $conn->query("SELECT COUNT(id) FROM domains");
$total_domains = $total_domains_q->fetch_row()[0];
?>

<h3>Pengaturan Sistem Global</h3>
<?php 
// Tampilkan pesan sukses atau error jika ada dari proses sebelumnya
if(isset($_GET['status']) && $_GET['status'] == 'success') {
    $msg = $_GET['msg'] ?? 'Pengaturan berhasil disimpan.';
    echo '<div class="alert alert-success">' . e($msg) . '</div>';
}
if(isset($_GET['status']) && $_GET['status'] == 'error') {
    $msg = $_GET['msg'] ?? 'Terjadi kesalahan.';
    echo '<div class="alert alert-danger">' . e($msg) . '</div>';
}
?>

<div class="summary-cards">
    <div class="card"><h3>Total Pengguna</h3><p><?php echo $total_users; ?></p></div>
    <div class="card"><h3>Total Domain</h3><p><?php echo $total_domains; ?></p></div>
</div>


<form action="process_admin.php" method="POST">
    <input type="hidden" name="action" value="update_settings">

    <div class="setting-card">
        <h4>Pengaturan Bot Telegram</h4>
        <div class="form-group">
            <label><strong>Bot Token</strong></label>
            <input type="text" class="form-control" name="telegram_bot_token" value="<?php echo e($settings['telegram_bot_token'] ?? ''); ?>" placeholder="Contoh: 123456:ABC-DEF...">
            <small>Dapatkan dari @BotFather. <strong>Peringatan:</strong> Anda harus mengatur ulang webhook jika mengubah token ini.</small>
        </div>
        <div class="form-group">
            <label><strong>Bot Username</strong></label>
            <input type="text" class="form-control" name="telegram_bot_username" value="<?php echo e($settings['telegram_bot_username'] ?? ''); ?>" placeholder="Contoh: @NamaBotAnda">
            <small>Gunakan format dengan @. Ini akan ditampilkan di halaman tutorial dan dashboard.</small>
        </div>
    </div>
    
    <div class="setting-card">
        <h4>Pengaturan Masa Percobaan (Trial)</h4>
        <div class="form-group">
            <label><strong>Durasi Masa Percobaan (Hari)</strong></label>
            <input type="number" class="form-control" name="trial_duration_days" value="<?php echo e($settings['trial_duration_days'] ?? 7); ?>" min="1">
            <small>Jumlah hari pengguna baru bisa menikmati paket "Percobaan" sebelum otomatis di-downgrade.</small>
        </div>
        <div class="form-group">
            <label><strong>Paket Default Setelah Trial Habis</strong></label>
            <select name="default_package_after_trial" class="form-control">
                <?php mysqli_data_seek($packages_q, 0); // Reset pointer query agar bisa digunakan lagi ?>
                <?php while($pkg = $packages_q->fetch_assoc()): ?>
                    <?php if ($pkg['id'] == 1) continue; // Jangan izinkan downgrade ke paket Percobaan lagi ?>
                    <option value="<?php echo $pkg['id']; ?>" <?php echo (($settings['default_package_after_trial'] ?? 2) == $pkg['id']) ? 'selected' : ''; ?>>
                                                <?php echo e($pkg['name']); ?>
                    </option>
                <?php endwhile; ?>
            </select>
            <small>Pengguna akan otomatis dipindahkan ke paket ini setelah masa percobaan mereka berakhir.</small>
        </div>
    </div>

    <button type="submit" class="btn btn-primary" style="width: auto; font-size: 1.1rem; padding: 0.8rem 2rem;">Simpan Semua Pengaturan</button>
</form>

</div><!-- Tutup container dari header.php -->
</body>
</html>