<?php
// file: /public_html/admin/process_admin.php (Versi Final Utuh)

// Memanggil file konfigurasi dari direktori induk
require_once __DIR__ . '/../config.php';

// Proteksi: Pastikan hanya admin yang bisa mengakses file ini
if (!isset($_SESSION['user_id'])) { 
    exit('No session'); 
}
$admin_id = $_SESSION['user_id'];
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') { 
    exit('Access denied'); 
}

// Logika utama hanya berjalan jika ada permintaan POST dengan 'action'
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    
    $action = $_POST['action'];

    // ===================================================
    //      LOGIKA UNTUK AKSI "UPDATE USER"
    // ===================================================
    if ($action == 'update_user') {
        if (!isset($_POST['user_id'], $_POST['email'], $_POST['package_id'], $_POST['role'])) { 
            die("Error: Data dari form update user tidak lengkap."); 
        }
        $target_user_id = (int)$_POST['user_id'];
        $email = trim($_POST['email']);
        $contact = trim($_POST['contact'] ?? '');
        $package_id = (int)$_POST['package_id'];
        $role = $_POST['role'];
        
        // Ambil kuota dari paket yang dipilih untuk sinkronisasi
        $pkg_stmt = $conn->prepare("SELECT quota FROM packages WHERE id = ?");
        $pkg_stmt->bind_param("i", $package_id);
        $pkg_stmt->execute();
        $quota_res = $pkg_stmt->get_result();
        $quota = ($quota_res->num_rows > 0) ? $quota_res->fetch_assoc()['quota'] : 1;
        $pkg_stmt->close();

        // Update data di tabel users
        $update_stmt = $conn->prepare("UPDATE users SET email=?, contact=?, role=?, package_id=?, quota_total=? WHERE id=?");
        $update_stmt->bind_param("sssiii", $email, $contact, $role, $package_id, $quota, $target_user_id);
        if ($update_stmt->execute()) {
            logActivity("Admin (ID: $admin_id) mengupdate user ID: $target_user_id", $admin_id);
        }
        $update_stmt->close();
        
        header("Location: index.php?status=updated");
        exit();
    
    // ===================================================
    //      LOGIKA UNTUK AKSI "DELETE USER"
    // ===================================================
    } elseif ($action == 'delete_user') {
        $target_user_id = (int)$_POST['user_id'];
        // Keamanan: Mencegah admin menghapus dirinya sendiri
        if ($target_user_id == $admin_id) { 
            header("Location: index.php?status=delete_self_error"); 
            exit(); 
        }
        
        $delete_stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
        $delete_stmt->bind_param("i", $target_user_id);
        if ($delete_stmt->execute()) {
            logActivity("Admin (ID: $admin_id) menghapus user ID: $target_user_id", $admin_id);
        }
        $delete_stmt->close();
        
        header("Location: index.php?status=deleted");
        exit();
    
    // ===================================================
    //      LOGIKA UNTUK AKSI "RESET PASSWORD"
    // ===================================================
    } elseif ($action == 'reset_password') {
        if (isset($_POST['user_id'])) {
            $target_user_id = (int)$_POST['user_id'];
            // Admin tidak bisa reset password sendiri dari sini
            if ($target_user_id == $admin_id) { 
                header("Location: index.php"); 
                exit(); 
            }
            
            $new_default_password = '12345678';
            $hashed_password = password_hash($new_default_password, PASSWORD_DEFAULT);
            
            $stmt = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            if ($stmt) {
                $stmt->bind_param("si", $hashed_password, $target_user_id);
                if ($stmt->execute()) {
                    logActivity("Admin (ID: $admin_id) mereset password untuk user ID: $target_user_id", $admin_id);
                }
                $stmt->close();
            }
            
            header("Location: index.php?status=pass_reset");
            exit();
        }

    // ===================================================
    //      LOGIKA UNTUK AKSI "CLEAR LOGS"
    // ===================================================
    } elseif ($action == 'clear_logs') {
        if ($conn->query("TRUNCATE TABLE activity_logs")) {
            logActivity("Admin (ID: $admin_id) menghapus semua log aktivitas.", $admin_id);
        }
        header("Location: activity_log.php?status=logs_cleared");
        exit();

    // ===================================================
    //      LOGIKA UNTUK AKSI "UPDATE SETTINGS"
    // ===================================================
    } elseif ($action == 'update_settings') {
        $stmt = $conn->prepare("INSERT INTO settings (setting_name, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
        $stmt->bind_param("ss", $setting_name, $setting_value);
        
        $settings_to_update = ['trial_duration_days', 'default_package_after_trial', 'telegram_bot_token', 'telegram_bot_username'];
        $old_token = TELEGRAM_BOT_TOKEN;
        
        foreach ($settings_to_update as $key) {
            if (isset($_POST[$key])) {
                $setting_name = $key;
                $setting_value = trim($_POST[$key]);
                $stmt->execute();
            }
        }
        $stmt->close();
        
        logActivity("Admin (ID: $admin_id) memperbarui pengaturan sistem.", $admin_id);
        
        $message = "Pengaturan berhasil disimpan.";
        if ($old_token !== trim($_POST['telegram_bot_token'])) {
            $message .= " PERINGATAN: Anda mengubah Bot Token. Anda HARUS mengatur ulang webhook bot Anda agar tetap berfungsi!";
        }
        
        header("Location: settings.php?status=success&msg=" . urlencode($message));
        exit();
    }
}

// Jika tidak ada aksi yang cocok, arahkan kembali ke halaman utama admin
header("Location: index.php"); 
exit();
?>