<?php
// file: /admin/process_add_user.php
// File ini tidak menampilkan HTML, hanya memproses data.

require_once __DIR__ . '/../config.php';

// 1. Keamanan: Pastikan admin yang login dan metodenya POST
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    die("Akses ditolak. Anda harus login sebagai admin.");
}

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    // Jika ada yang mencoba mengakses file ini langsung, tendang keluar.
    header("Location: add_user.php");
    exit();
}

// 2. Ambil data dari formulir
$email = trim($_POST['email']);
$password = $_POST['password'];
$contact = trim($_POST['contact']);
$package_id = $_POST['package_id'];
$role = $_POST['role'];

// 3. Validasi Data
if (empty($email) || empty($password) || empty($package_id) || empty($role)) {
    header("Location: add_user.php?status=error&msg=empty");
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    header("Location: add_user.php?status=error&msg=invalid_email");
    exit();
}

if (strlen($password) < 8) {
    header("Location: add_user.php?status=error&msg=password_short");
    exit();
}

// 4. Cek apakah email sudah ada di database
$stmt_check = $conn->prepare("SELECT id FROM users WHERE email = ?");
$stmt_check->bind_param("s", $email);
$stmt_check->execute();
$stmt_check->store_result();

if ($stmt_check->num_rows > 0) {
    // Email sudah ada
    $stmt_check->close();
    header("Location: add_user.php?status=error&msg=email_exists");
    exit();
}
$stmt_check->close();

// 5. Hash password sebelum disimpan (SANGAT PENTING!)
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

// 6. Siapkan dan jalankan query INSERT
$stmt_insert = $conn->prepare("INSERT INTO users (email, password, contact, package_id, role, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
// Tipe data: s = string, i = integer
$stmt_insert->bind_param("sssis", $email, $hashed_password, $contact, $package_id, $role);

if ($stmt_insert->execute()) {
    // Jika berhasil, arahkan kembali ke halaman daftar pengguna dengan pesan sukses
    header("Location: index.php?status=user_added");
    exit();
} else {
    // Jika gagal, arahkan kembali ke form dengan pesan error
    header("Location: add_user.php?status=error&msg=db_error");
    exit();
}

$stmt_insert->close();
$conn->close();
?>