<?php 
// file: /public_html/admin/manage_user.php

require_once 'header.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) { header("Location: index.php"); exit(); }
$target_user_id = (int)$_GET['id'];

// Ambil data user yang akan diedit
$stmt = $conn->prepare("SELECT id, email, contact, package_id, role FROM users WHERE id = ?");
$stmt->bind_param("i", $target_user_id);
$stmt->execute();
$target_user = $stmt->get_result()->fetch_assoc();
$stmt->close(); 
if (!$target_user) { die("User tidak ditemukan."); }

// Ambil semua paket untuk dropdown
$packages_q = $conn->query("SELECT id, name, quota FROM packages");
?>

<h3>Edit Pengguna: <?php echo e($target_user['email']); ?></h3>

<form action="process_admin.php" method="POST">
    <input type="hidden" name="action" value="update_user">
    <input type="hidden" name="user_id" value="<?php echo $target_user['id']; ?>">

    <div class="form-group">
        <label>Email</label>
        <input type="email" name="email" class="form-control" value="<?php echo e($target_user['email']); ?>" required>
    </div>
    <div class="form-group">
        <label>Kontak</label>
        <input type="text" name="contact" class="form-control" value="<?php echo e($target_user['contact']); ?>">
    </div>
    <div class="form-group">
        <label>Paket Langganan</label>
        <select name="package_id" class="form-control">
            <?php while($pkg = $packages_q->fetch_assoc()): ?>
                <option value="<?php echo $pkg['id']; ?>" <?php echo ($target_user['package_id'] == $pkg['id']) ? 'selected' : ''; ?>>
                    <?php echo e($pkg['name']); ?> (Kuota: <?php echo $pkg['quota']; ?>)
                </option>
            <?php endwhile; ?>
        </select>
    </div>
    <div class="form-group">
        <label>Role</label>
        <select name="role" class="form-control">
            <option value="user" <?php if($target_user['role'] == 'user') echo 'selected'; ?>>User</option>
            <option value="admin" <?php if($target_user['role'] == 'admin') echo 'selected'; ?>>Admin</option>
        </select>
    </div>
    <button type="submit" class="btn btn-primary" style="width: auto;">Update User</button>
</form>

</div><!-- Tutup container dari header.php -->
</body>
</html>