<?php
// file: /admin/manage_domains.php (Versi Rapi dan Konsisten)

require_once 'header.php';

// --- FUNGSI HELPER & LOGIKA PHP ---
if (!function_exists('e')) {
    function e($string) { return htmlspecialchars($string, ENT_QUOTES, 'UTF-8'); }
}

$limit = 20;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// --- Logika Pencarian (BARU) ---
$where_clauses = [];
$params = [];
$types = "";

if (!empty($_GET['search'])) {
    $search_param = '%' . $_GET['search'] . '%';
    // Mencari berdasarkan nama domain ATAU email pemilik
    $where_clauses[] = "(d.name LIKE ? OR u.email LIKE ?)";
    $params[] = $search_param;
    $params[] = $search_param;
    $types .= "ss";
}

$where_sql = count($where_clauses) > 0 ? " WHERE " . implode(" AND ", $where_clauses) : "";

// Query untuk menghitung total hasil yang difilter
$total_domains_q = "SELECT COUNT(d.id) as total FROM domains d JOIN users u ON d.user_id = u.id" . $where_sql;
$stmt_total = $conn->prepare($total_domains_q);
if (!empty($types)) {
    $stmt_total->bind_param($types, ...$params);
}
$stmt_total->execute();
$total_domains = $stmt_total->get_result()->fetch_assoc()['total'];
$total_pages = ceil($total_domains / $limit);
$stmt_total->close();

// Query utama untuk mengambil data domain
$all_domains_q_sql = "SELECT d.id, d.name, d.url, d.is_active, u.email as owner_email FROM domains d JOIN users u ON d.user_id = u.id" . $where_sql . " ORDER BY d.id DESC LIMIT ?, ?";
$params_main = array_merge($params, [$offset, $limit]);
$types_main = $types . "ii";

$stmt_main = $conn->prepare($all_domains_q_sql);
if (!empty($types_main)) {
    $stmt_main->bind_param($types_main, ...$params_main);
}
$stmt_main->execute();
$all_domains = $stmt_main->get_result();
$stmt_main->close();

?>
<!-- Menggunakan style yang sama dengan halaman index.php untuk konsistensi -->
<style>
    .page-title { font-size: 1.75rem; font-weight: 500; margin-bottom: 0.5rem; }
    .breadcrumb { list-style: none; padding: 0; margin-bottom: 2rem; }
    .breadcrumb li { display: inline; font-size: 0.9rem; }
    .breadcrumb li+li::before { content: "/\00a0"; color: #6c757d; }
    .data-panel { background: #fff; border: 1px solid #e3e6f0; border-radius: 8px; }
    .panel-header, .panel-filter { padding: 1rem 1.25rem; border-bottom: 1px solid #e3e6f0; }
    .panel-header { background: #f8f9fc; font-weight: bold; color: #343a40; }
    .panel-filter input, .panel-filter button { padding: 8px; border: 1px solid #ccc; border-radius: 4px; margin-right: 10px; }
    .panel-filter button { background: #343a40; color: white; cursor: pointer; }
    .panel-body { padding: 1.25rem; }
    .data-table { width: 100%; border-collapse: collapse; }
    .data-table th, .data-table td { padding: 12px; border-bottom: 1px solid #e3e6f0; text-align: left; }
    .data-table thead th { background: #f8f9fc; }
    .status-badge { padding: 3px 8px; border-radius: 10px; font-size: 0.8rem; font-weight: bold; color: white; }
    .status-on { background-color: #28a745; }
    .status-off { background-color: #6c757d; }
    .action-buttons button, .action-buttons a { background: none; border: none; cursor: pointer; font-size: 1rem; color: #5a5c69; margin: 0 4px; }
    .action-buttons a:hover, .action-buttons button:hover { color: #c82333; }
    .pagination { text-align: center; margin-top: 2rem; }
    .pagination a { text-decoration: none; padding: 8px 12px; border: 1px solid #ddd; margin: 0 2px; }
    .pagination a.active { background: #343a40; color: white; border-color: #343a40; }
</style>

<!-- KONTEN HALAMAN DIMULAI -->
<h1 class="page-title">Manajemen Semua Domain</h1>
<ol class="breadcrumb">
    <li><a href="index.php">Home</a></li>
    <li>Manajemen Domain</li>
</ol>

<!-- Panel Tabel Domain -->
<div class="data-panel">
    <div class="panel-header">
        Daftar Domain (Total: <?php echo $total_domains; ?>)
    </div>
    <!-- Filter Pencarian (BARU) -->
    <div class="panel-filter">
        <form method="GET" action="manage_domains.php">
            <input type="text" name="search" placeholder="Cari nama domain atau email pemilik..." value="<?php echo e($_GET['search'] ?? ''); ?>" style="width: 300px;">
            <button type="submit"><i class="fas fa-search"></i> Cari</button>
        </form>
    </div>
    <div class="panel-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nama Domain</th>
                    <th>URL</th>
                    <th>Pemilik</th>
                    <th>Status</th>
                    <th style="text-align: center;">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($all_domains->num_rows > 0): ?>
                    <?php while($d = $all_domains->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $d['id']; ?></td>
                        <td><?php echo e($d['name']); ?></td>
                        <td><code><?php echo e($d['url']); ?></code></td>
                        <td><?php echo e($d['owner_email']); ?></td>
                        <td>
                            <?php if ($d['is_active']): ?>
                                <span class="status-badge status-on">AKTIF</span>
                            <?php else: ?>
                                <span class="status-badge status-off">NONAKTIF</span>
                            <?php endif; ?>
                        </td>
                        <td class="action-buttons" style="text-align: center;">
                            <!-- Link ke edit domain di folder luar, sesuai kode asli Anda -->
                            <a href="../edit_domain.php?id=<?php echo $d['id']; ?>&ref=admin" title="Edit Domain"><i class="fas fa-edit"></i></a>
                            
                            <!-- Form hapus domain, proses di folder luar, sesuai kode asli Anda -->
                            <form action="../process_domain.php" method="POST" style="display: inline;" onsubmit="return confirm('Anda yakin ingin menghapus domain ini?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="domain_id" value="<?php echo $d['id']; ?>">
                                <input type="hidden" name="ref" value="admin">
                                <button type="submit" title="Hapus Domain"><i class="fas fa-trash"></i></button>
                            </form>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="6" style="text-align: center; padding: 20px;">Tidak ada domain yang cocok dengan kriteria pencarian.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Paginasi yang Rapi -->
<?php if($total_pages > 1): ?>
<div class="pagination">
    <?php for($i = 1; $i <= $total_pages; $i++): ?>
        <a href="?page=<?php echo $i; ?>&search=<?php echo e($_GET['search'] ?? ''); ?>" class="<?php if($i == $page) echo 'active'; ?>">
            <?php echo $i; ?>
        </a>
    <?php endfor; ?>
</div>
<?php endif; ?>

<?php
require_once 'footer.php'; // PENTING: Memanggil footer untuk menutup halaman
?>