<?php
// file: /public_html/admin/index.php (Versi final, terintegrasi dengan template Anda)

require_once 'header.php'; // Memanggil header yang sudah Anda perbaiki

// --- FUNGSI HELPER & LOGIKA PHP (TIDAK PERLU DIUBAH) ---
if (!function_exists('e')) {
    function e($string) { return htmlspecialchars($string, ENT_QUOTES, 'UTF-8'); }
}
$total_users_q = $conn->query("SELECT COUNT(id) FROM users");
$total_users = $total_users_q->fetch_row()[0] ?? 0;
$total_domains_q = $conn->query("SELECT COUNT(id) FROM domains");
$total_domains = $total_domains_q->fetch_row()[0] ?? 0;
$active_trials_q = $conn->query("SELECT COUNT(id) FROM users WHERE trial_expires_at IS NOT NULL AND trial_expires_at > NOW()");
$active_trials = $active_trials_q->fetch_row()[0] ?? 0;

$limit = 15;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;
$where_clauses = [];
$params = [];
$types = "";
if (!empty($_GET['search'])) {
    $search_param = '%' . $_GET['search'] . '%';
    $where_clauses[] = "(u.email LIKE ? OR u.contact LIKE ?)";
    $params[] = $search_param; $params[] = $search_param;
    $types .= "ss";
}
if (!empty($_GET['package_id']) && is_numeric($_GET['package_id'])) {
    $package_param = (int)$_GET['package_id'];
    $where_clauses[] = "u.package_id = ?";
    $params[] = $package_param;
    $types .= "i";
}
$where_sql = count($where_clauses) > 0 ? " WHERE " . implode(" AND ", $where_clauses) : "";
$total_filtered_q = "SELECT COUNT(u.id) as total FROM users u" . $where_sql;
$stmt_total = $conn->prepare($total_filtered_q);
if (!empty($types)) { $stmt_total->bind_param($types, ...$params); }
$stmt_total->execute();
$total_filtered_users = $stmt_total->get_result()->fetch_assoc()['total'];
$total_pages = ceil($total_filtered_users / $limit);
$stmt_total->close();

$main_query = "SELECT u.id, u.email, u.contact, u.role, p.name as package_name FROM users u LEFT JOIN packages p ON u.package_id = p.id" . $where_sql . " ORDER BY u.id DESC LIMIT ?, ?";
$params_main = array_merge($params, [$offset, $limit]);
$types_main = $types . "ii";
$stmt_main = $conn->prepare($main_query);
if (!empty($types_main)) { $stmt_main->bind_param($types_main, ...$params_main); }
$stmt_main->execute();
$all_users = $stmt_main->get_result();
$stmt_main->close();
$packages = $conn->query("SELECT id, name FROM packages");
?>
<!-- CSS KHUSUS UNTUK HALAMAN INI -->
<!-- Anda bisa memindahkan ini ke style.css jika mau -->
<style>
    .page-title { font-size: 1.75rem; font-weight: 500; margin-bottom: 0.5rem; }
    .breadcrumb { list-style: none; padding: 0; margin-bottom: 2rem; }
    .breadcrumb li { display: inline; font-size: 0.9rem; }
    .breadcrumb li+li::before { content: "/\00a0"; color: #6c757d; }
    .stats-container { display: flex; gap: 20px; margin-bottom: 2rem; flex-wrap: wrap; }
    .stat-card { flex: 1; background: #fff; padding: 20px; border: 1px solid #e3e6f0; border-radius: 8px; text-align: center; }
    .stat-card-icon { font-size: 2rem; color: #858796; margin-bottom: 0.5rem; }
    .stat-card-number { font-size: 1.5rem; font-weight: bold; }
    .stat-card-title { font-size: 0.8rem; text-transform: uppercase; color: #858796; }
    .data-panel { background: #fff; border: 1px solid #e3e6f0; border-radius: 8px; }
    .panel-header, .panel-filter { padding: 1rem 1.25rem; border-bottom: 1px solid #e3e6f0; }
    .panel-header { background: #f8f9fc; font-weight: bold; color: #c82333; }
    .panel-header a { background-color: #c82333; color: white; padding: 8px 12px; text-decoration: none; border-radius: 5px; font-size: 0.9rem;}
    .panel-filter input, .panel-filter select { padding: 8px; border: 1px solid #ccc; border-radius: 4px; margin-right: 10px; }
    .panel-filter button { background: #343a40; color: white; padding: 8px 15px; border: none; border-radius: 4px; cursor: pointer; }
    .panel-body { padding: 1.25rem; }
    .data-table { width: 100%; border-collapse: collapse; }
    .data-table th, .data-table td { padding: 12px; border-bottom: 1px solid #e3e6f0; text-align: left; }
    .data-table thead th { background: #f8f9fc; }
    .action-buttons button, .action-buttons a { background: none; border: none; cursor: pointer; font-size: 1rem; color: #5a5c69; margin: 0 4px; }
    .action-buttons a:hover, .action-buttons button:hover { color: #c82333; }
    .pagination { text-align: center; margin-top: 2rem; }
    .pagination a { text-decoration: none; padding: 8px 12px; border: 1px solid #ddd; margin: 0 2px; }
    .pagination a.active { background: #343a40; color: white; border-color: #343a40; }
</style>

<!-- KONTEN HALAMAN DIMULAI -->
<h1 class="page-title">Manajemen Pengguna</h1>
<ol class="breadcrumb">
    <li><a href="index.php">Home</a></li>
    <li>Pengguna</li>
</ol>

<!-- Kartu Statistik -->
<div class="stats-container">
    <div class="stat-card">
        <div class="stat-card-icon"><i class="fas fa-users"></i></div>
        <div class="stat-card-number"><?php echo $total_users; ?></div>
        <div class="stat-card-title">Total Pengguna</div>
    </div>
    <div class="stat-card">
        <div class="stat-card-icon"><i class="fas fa-globe"></i></div>
        <div class="stat-card-number"><?php echo $total_domains; ?></div>
        <div class="stat-card-title">Total Domain</div>
    </div>
    <div class="stat-card">
        <div class="stat-card-icon"><i class="fas fa-hourglass-half"></i></div>
        <div class="stat-card-number"><?php echo $active_trials; ?></div>
        <div class="stat-card-title">Trial Aktif</div>
    </div>
</div>

<!-- Panel Tabel Pengguna -->
<div class="data-panel">
    <div class="panel-header">
        <a href="add_user.php"><i class="fas fa-plus"></i> Tambah Pengguna Baru</a>
    </div>
    <div class="panel-filter">
        <form method="GET" action="index.php">
            <input type="text" name="search" placeholder="Cari email atau kontak..." value="<?php echo e($_GET['search'] ?? ''); ?>">
            <select name="package_id">
                <option value="">Semua Paket</option>
                <?php while($pkg = $packages->fetch_assoc()): ?>
                    <option value="<?php echo $pkg['id']; ?>" <?php if(isset($_GET['package_id']) && $_GET['package_id'] == $pkg['id']) echo 'selected'; ?>><?php echo e($pkg['name']); ?></option>
                <?php endwhile; ?>
            </select>
            <button type="submit"><i class="fas fa-filter"></i> Terapkan Filter</button>
        </form>
    </div>
    <div class="panel-body">
        <table class="data-table">
            <thead>
                <tr>
                    <th>ID</th><th>Email</th><th>Kontak</th><th>Paket</th><th>Role</th><th style="text-align: center;">Aksi</th>
                </tr>
            </thead>
            <tbody>
            <?php if ($all_users && $all_users->num_rows > 0): ?>
                <?php while($u = $all_users->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $u['id']; ?></td>
                    <td><?php echo e($u['email']); ?></td>
                    <td><?php echo e($u['contact'] ?? '-'); ?></td>
                    <td><?php echo e($u['package_name'] ?? 'N/A'); ?></td>
                    <td><?php echo e($u['role']); ?></td>
                    <td class="action-buttons" style="text-align: center;">
                        <a href="manage_user.php?id=<?php echo $u['id']; ?>" title="Edit Pengguna"><i class="fas fa-edit"></i></a>
                        <?php if ($u['id'] != $_SESSION['user_id']): ?>
                            <form action="process_admin.php" method="POST" style="display: inline;" onsubmit="return confirm('Reset password menjadi `12345678`?');">
                                <input type="hidden" name="action" value="reset_password"><input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                                <button type="submit" title="Reset Password"><i class="fas fa-key"></i></button>
                            </form>
                            <form action="process_admin.php" method="POST" style="display: inline;" onsubmit="return confirm('Hapus pengguna ini dan semua domainnya?');">
                                <input type="hidden" name="action" value="delete_user"><input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                                <button type="submit" title="Hapus Pengguna"><i class="fas fa-trash"></i></button>
                            </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="6" style="text-align: center; padding: 20px;">Tidak ada pengguna yang ditemukan.</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Paginasi -->
<?php if($total_pages > 1): ?>
<div class="pagination">
    <?php for($i = 1; $i <= $total_pages; $i++): ?>
        <a href="?page=<?php echo $i; ?>&search=<?php echo e($_GET['search'] ?? ''); ?>&package_id=<?php echo e($_GET['package_id'] ?? ''); ?>" class="<?php if($i == $page) echo 'active'; ?>"><?php echo $i; ?></a>
    <?php endfor; ?>
</div>
<?php endif; ?>

<?php
require_once 'footer.php'; // Memanggil footer untuk menutup halaman
?>