<?php
// file: /admin/add_user.php

require_once 'header.php'; // Memanggil header template admin

// Ambil daftar paket untuk dropdown
$packages = $conn->query("SELECT id, name FROM packages ORDER BY name ASC");

if (!function_exists('e')) {
    function e($string) { return htmlspecialchars($string, ENT_QUOTES, 'UTF-8'); }
}
?>
<!-- CSS khusus untuk form, bisa dipindahkan ke style.css jika mau -->
<style>
    .form-panel { background: #fff; border: 1px solid #e3e6f0; border-radius: 8px; }
    .form-header { padding: 1rem 1.25rem; background: #f8f9fc; font-weight: bold; border-bottom: 1px solid #e3e6f0; }
    .form-body { padding: 1.5rem; }
    .form-group { margin-bottom: 1.25rem; }
    .form-group label { display: block; margin-bottom: 0.5rem; font-weight: 500; }
    .form-group input,
    .form-group select {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 5px;
        box-sizing: border-box; /* Penting agar padding tidak menambah lebar */
    }
    .form-group .note { font-size: 0.8rem; color: #858796; margin-top: 5px;}
    .form-actions button {
        background-color: #c82333;
        color: white;
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        font-size: 1rem;
        font-weight: bold;
    }
    .form-actions a {
        color: #5a5c69;
        text-decoration: none;
        margin-left: 15px;
    }
    .alert {
        padding: 1rem;
        margin-bottom: 1rem;
        border: 1px solid transparent;
        border-radius: 5px;
    }
    .alert-danger { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; }
    .alert-success { color: #155724; background-color: #d4edda; border-color: #c3e6cb; }
</style>

<h1 class="page-title">Tambah Pengguna Baru</h1>
<ol class="breadcrumb">
    <li><a href="index.php">Manajemen Pengguna</a></li>
    <li>Tambah Baru</li>
</ol>

<div class="form-panel">
    <div class="form-header">
        Formulir Data Pengguna
    </div>
    <form action="process_add_user.php" method="POST" class="form-body">
        
        <?php if (isset($_GET['status'])): ?>
            <div class="alert alert-danger">
                <?php
                if ($_GET['msg'] == 'empty') echo 'Semua kolom yang ditandai * wajib diisi.';
                if ($_GET['msg'] == 'invalid_email') echo 'Format email tidak valid.';
                if ($_GET['msg'] == 'password_short') echo 'Password minimal harus 8 karakter.';
                if ($_GET['msg'] == 'email_exists') echo 'Email ini sudah terdaftar. Silakan gunakan email lain.';
                if ($_GET['msg'] == 'db_error') echo 'Terjadi kesalahan pada database. Coba lagi nanti.';
                ?>
            </div>
        <?php endif; ?>

        <div class="form-group">
            <label for="email">Alamat Email *</label>
            <input type="email" id="email" name="email" required>
        </div>

        <div class="form-group">
            <label for="password">Password *</label>
            <input type="password" id="password" name="password" required>
            <p class="note">Minimal 8 karakter. Pengguna dapat mengubahnya nanti.</p>
        </div>

        <div class="form-group">
            <label for="contact">Kontak (No. HP / Username)</label>
            <input type="text" id="contact" name="contact">
        </div>

        <div class="form-group">
            <label for="package_id">Paket Langganan *</label>
            <select id="package_id" name="package_id" required>
                <option value="">-- Pilih Paket --</option>
                <?php while($pkg = $packages->fetch_assoc()): ?>
                    <option value="<?php echo $pkg['id']; ?>"><?php echo e($pkg['name']); ?></option>
                <?php endwhile; ?>
            </select>
        </div>

        <div class="form-group">
            <label for="role">Role / Peran *</label>
            <select id="role" name="role" required>
                <option value="user" selected>User</option>
                <option value="admin">Admin</option>
            </select>
        </div>

        <div class="form-actions">
            <button type="submit">Simpan Pengguna</button>
            <a href="index.php">Batal</a>
        </div>
    </form>
</div>

<?php
require_once 'footer.php'; // Memanggil footer untuk menutup halaman
?>