<?php
// file: /public_html/admin/activity_log.php

require_once 'header.php';

// Logika Paginasi
$limit = 50; // Jumlah log per halaman
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Menghitung total log untuk paginasi
$total_logs_q = $conn->query("SELECT COUNT(id) as total FROM activity_logs");
$total_logs = $total_logs_q->fetch_assoc()['total'];
$total_pages = ceil($total_logs / $limit);

// Mengambil data log untuk halaman saat ini
$logs_q = $conn->prepare("SELECT * FROM activity_logs ORDER BY id DESC LIMIT ? OFFSET ?");
$logs_q->bind_param("ii", $limit, $offset);
$logs_q->execute();
$logs = $logs_q->get_result();
?>

<div class="d-flex justify-content-between align-items-center">
    <h3>Log Aktivitas Sistem (Total: <?php echo $total_logs; ?>)</h3>
    
    <form action="process_admin.php" method="POST" onsubmit="return confirm('Anda yakin ingin menghapus SEMUA catatan log aktivitas? Aksi ini tidak bisa dibatalkan.');">
        <input type="hidden" name="action" value="clear_logs">
        <button type="submit" class="btn btn-danger" <?php if ($total_logs == 0) echo 'disabled'; ?>>Clear All Logs</button>
    </form>
</div>

<?php 
if (isset($_GET['status']) && $_GET['status'] == 'logs_cleared') {
    echo '<div class="alert alert-success mt-3">Semua log aktivitas berhasil dihapus.</div>';
}
?>

<div class="table-wrapper mt-3">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th style="width: 10%;">ID Log</th>
                <th style="width: 15%;">User ID</th>
                <th style="width: 50%;">Aksi</th>
                <th style="width: 25%;">Waktu</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($logs->num_rows > 0): ?>
                <?php while($log = $logs->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $log['id']; ?></td>
                    <td><?php echo $log['user_id'] ?? '<i>Sistem/Cron</i>'; ?></td>
                    <td><?php echo e($log['action']); ?></td>
                    <td><?php echo $log['created_at']; ?></td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="4" class="text-center p-4">Tidak ada log aktivitas.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Navigasi Paginasi -->
<div style="margin-top: 1rem; text-align:center; padding: 1rem; display: flex; justify-content: space-between;">
    <div>
        <?php if($page > 1): ?>
            <a href="?page=<?php echo $page - 1; ?>" class="btn btn-primary" style="width:auto;">« Previous</a>
        <?php endif; ?>
    </div>
    <div class="align-self-center">
        <span>Halaman <?php echo $page; ?> dari <?php echo $total_pages; ?></span>
    </div>
    <div>
        <?php if($page < $total_pages): ?>
            <a href="?page=<?php echo $page + 1; ?>" class="btn btn-primary" style="width:auto;">Next »</a>
        <?php endif; ?>
    </div>
</div>

</div><!-- Tutup container dari header.php -->
</body>
</html>